﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace memoQSampleCMSConnector
{
	public partial class MainForm : Form
	{

		public MainForm()
		{
			InitializeComponent();

			ComboboxItem item1 = new ComboboxItem();
			item1.Text = "Local folder";
			item1.Value = Mode.Virtual;

			cbCMSConnection.Items.Add(item1);

			ComboboxItem item2 = new ComboboxItem();
			item2.Text = "Jira";
			item2.Value = Mode.Jira;

			cbCMSConnection.Items.Add(item2);
			cbCMSConnection.SelectedIndex = 0;

			tbLogPath.Text = Log.logPath;
			tbSettingsPath.Text = ConfigurationHelper.realConfigFilePath;
		}

		private void btnNewProject_Click(object sender, EventArgs e)
		{
			try
			{
				ConfigurationHelper.Config.mode = (cbCMSConnection.SelectedItem as ComboboxItem).Value;
				TransferCMS2memoQ tcm = new TransferCMS2memoQ();
			}
			catch (Exception ex)
			{
				Log.AddLog("Error while transferring translatable files from CMS to memoQ: " + ex.Message, MessageType.Error);
			}
		}


		private void btnGetTranslation_Click(object sender, EventArgs e)
		{
			try
			{
				ConfigurationHelper.Config.mode = (cbCMSConnection.SelectedItem as ComboboxItem).Value;
				TransfermemoQ2CMS tmc = new TransfermemoQ2CMS();
			}
			catch (Exception ex)
			{
				Log.AddLog("Error while transferring translatable files from memoQ to CMS: " + ex.Message, MessageType.Error);
			}
		}

		public void RefreshMessages()
		{
			foreach (ColoredMessage message in Log.messages)
			{
				if (!message.isPublished)
				{
					ProgressWindow.SelectionColor = message.Color;
					ProgressWindow.AppendText(message.Message + "\r\n");
					message.isPublished = true;
				}
			}

			ProgressWindow.Refresh();
			ProgressWindow.SelectionStart = ProgressWindow.Text.Length;
			ProgressWindow.ScrollToCaret();
			Application.DoEvents();

		}

		private void btnExit_Click(object sender, EventArgs e)
		{
            ConfigurationHelper.SaveChanges();
            this.Dispose();
		}

        private void label4_Click(object sender, EventArgs e)
        {

        }

        private void tbInputFolder_TextChanged(object sender, EventArgs e)
        {
            tbOutputFolder.Text = (tbInputFolder.Text + "\\Output\\").Replace(@"\\", @"\");
            ConfigurationHelper.Config.InputFolderPath = tbInputFolder.Text;
            ConfigurationHelper.Config.InputFolder = ConfigurationHelper.Config.InputFolderPath;
            ConfigurationHelper.Config.OutputFolderPath = tbOutputFolder.Text;
            ConfigurationHelper.Config.OutputFolder = ConfigurationHelper.Config.OutputFolderPath;
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void cmdBrowse_Click(object sender, EventArgs e)
        {
            
            if (folderBrowser.ShowDialog() == DialogResult.OK)
            {
                tbInputFolder.Text = folderBrowser.SelectedPath;
                tbOutputFolder.Text = (tbInputFolder.Text + "\\Output\\").Replace(@"\\", @"\");
            }
            
        }

        private void chkUseFileType_CheckedChanged(object sender, EventArgs e)
        {
            ConfigurationHelper.Config.UseFileType = chkUseFileType.Checked;
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            tbInputFolder.Text = ConfigurationHelper.Config.InputFolderPath;
            tbOutputFolder.Text = ConfigurationHelper.Config.OutputFolderPath;
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            ConfigurationHelper.SaveChanges();
        }

        private void label2_Click(object sender, EventArgs e)
        {

        }

        private void label3_Click(object sender, EventArgs e)
        {

        }
    }

    public class ComboboxItem
	{
		public string Text { get; set; }
		public Mode Value { get; set; }

		public override string ToString()
		{
			return Text;
		}
	}
}
